/*
 * Decompiled with CFR 0.152.
 */
package mod.beethoven92.betterendforge.common.world.generator;

import java.util.Random;
import java.util.concurrent.locks.ReentrantLock;
import mod.beethoven92.betterendforge.common.util.ModMathHelper;
import mod.beethoven92.betterendforge.common.world.generator.IslandLayer;
import mod.beethoven92.betterendforge.common.world.generator.OpenSimplexNoise;
import mod.beethoven92.betterendforge.config.CommonConfig;
import net.minecraft.util.math.MathHelper;

public class TerrainGenerator {
    private static final ReentrantLock LOCKER = new ReentrantLock();
    private static final double SCALE_XZ = 8.0;
    private static final double SCALE_Y = 4.0;
    private static final int CENTER = ModMathHelper.floor(62.5);
    private static IslandLayer largeIslands;
    private static IslandLayer mediumIslands;
    private static IslandLayer smallIslands;
    private static OpenSimplexNoise noise1;
    private static OpenSimplexNoise noise2;

    public static boolean canGenerate(int x, int z) {
        return CommonConfig.noRingVoid() || (long)x + (long)z > (long)CENTER;
    }

    public static void initNoise(long seed) {
        Random random = new Random(seed);
        largeIslands = new IslandLayer(random.nextInt(), 300.0, 200.0f, 70, 10, false);
        mediumIslands = new IslandLayer(random.nextInt(), 150.0, 100.0f, 70, 20, true);
        smallIslands = new IslandLayer(random.nextInt(), 60.0, 50.0f, 70, 30, false);
        noise1 = new OpenSimplexNoise(random.nextInt());
        noise2 = new OpenSimplexNoise(random.nextInt());
    }

    public static void fillTerrainDensity(double[] buffer, int x, int z) {
        LOCKER.lock();
        largeIslands.clearCache();
        mediumIslands.clearCache();
        smallIslands.clearCache();
        double distortion1 = noise1.eval((double)x * 0.1, (double)z * 0.1) * 20.0 + noise2.eval((double)x * 0.2, (double)z * 0.2) * 10.0 + noise1.eval((double)x * 0.4, (double)z * 0.4) * 5.0;
        double distortion2 = noise2.eval((double)x * 0.1, (double)z * 0.1) * 20.0 + noise1.eval((double)x * 0.2, (double)z * 0.2) * 10.0 + noise2.eval((double)x * 0.4, (double)z * 0.4) * 5.0;
        double px = (double)x * 8.0 + distortion1;
        double pz = (double)z * 8.0 + distortion2;
        largeIslands.updatePositions(px, pz);
        mediumIslands.updatePositions(px, pz);
        smallIslands.updatePositions(px, pz);
        for (int y = 0; y < buffer.length; ++y) {
            double py = (double)y * 4.0;
            float dist = largeIslands.getDensity(px, py, pz);
            dist = dist > 1.0f ? dist : ModMathHelper.max(dist, mediumIslands.getDensity(px, py, pz));
            float f = dist = dist > 1.0f ? dist : ModMathHelper.max(dist, smallIslands.getDensity(px, py, pz));
            if (dist > -0.5f) {
                dist = (float)((double)dist + (noise1.eval(px * 0.01, py * 0.01, pz * 0.01) * 0.02 + 0.02));
                dist = (float)((double)dist + (noise2.eval(px * 0.05, py * 0.05, pz * 0.05) * 0.01 + 0.01));
                dist = (float)((double)dist + (noise1.eval(px * 0.1, py * 0.1, pz * 0.1) * 0.005 + 0.005));
            }
            buffer[y] = dist;
        }
        LOCKER.unlock();
    }

    public static boolean isLand(int x, int z) {
        LOCKER.lock();
        double px = (double)(x >> 1) + 0.5;
        double pz = (double)(z >> 1) + 0.5;
        double distortion1 = noise1.eval(px * 0.1, pz * 0.1) * 20.0 + noise2.eval(px * 0.2, pz * 0.2) * 10.0 + noise1.eval(px * 0.4, pz * 0.4) * 5.0;
        double distortion2 = noise2.eval(px * 0.1, pz * 0.1) * 20.0 + noise1.eval(px * 0.2, pz * 0.2) * 10.0 + noise2.eval(px * 0.4, pz * 0.4) * 5.0;
        px = px * 8.0 + distortion1;
        pz = pz * 8.0 + distortion2;
        largeIslands.updatePositions(px, pz);
        mediumIslands.updatePositions(px, pz);
        smallIslands.updatePositions(px, pz);
        for (int y = 0; y < 32; ++y) {
            double py = (double)y * 4.0;
            float dist = largeIslands.getDensity(px, py, pz);
            dist = dist > 1.0f ? dist : ModMathHelper.max(dist, mediumIslands.getDensity(px, py, pz));
            float f = dist = dist > 1.0f ? dist : ModMathHelper.max(dist, smallIslands.getDensity(px, py, pz));
            if (dist > -0.5f) {
                dist = (float)((double)dist + (noise1.eval(px * 0.01, py * 0.01, pz * 0.01) * 0.02 + 0.02));
                dist = (float)((double)dist + (noise2.eval(px * 0.05, py * 0.05, pz * 0.05) * 0.01 + 0.01));
                dist = (float)((double)dist + (noise1.eval(px * 0.1, py * 0.1, pz * 0.1) * 0.005 + 0.005));
            }
            if (!((double)dist > -0.01)) continue;
            LOCKER.unlock();
            return true;
        }
        LOCKER.unlock();
        return false;
    }

    public static int getHeight(int x, int z) {
        LOCKER.lock();
        double px = (double)x / 8.0;
        double pz = (double)z / 8.0;
        double distortion1 = noise1.eval(px * 0.1, pz * 0.1) * 20.0 + noise2.eval(px * 0.2, pz * 0.2) * 10.0 + noise1.eval(px * 0.4, pz * 0.4) * 5.0;
        double distortion2 = noise2.eval(px * 0.1, pz * 0.1) * 20.0 + noise1.eval(px * 0.2, pz * 0.2) * 10.0 + noise2.eval(px * 0.4, pz * 0.4) * 5.0;
        px = (double)x * 8.0 + distortion1;
        pz = (double)z * 8.0 + distortion2;
        largeIslands.updatePositions(px, pz);
        mediumIslands.updatePositions(px, pz);
        smallIslands.updatePositions(px, pz);
        for (int y = 32; y >= 0; --y) {
            double py = (double)y * 4.0;
            float dist = largeIslands.getDensity(px, py, pz);
            dist = dist > 1.0f ? dist : ModMathHelper.max(dist, mediumIslands.getDensity(px, py, pz));
            float f = dist = dist > 1.0f ? dist : ModMathHelper.max(dist, smallIslands.getDensity(px, py, pz));
            if (dist > -0.5f) {
                dist = (float)((double)dist + (noise1.eval(px * 0.01, py * 0.01, pz * 0.01) * 0.02 + 0.02));
                dist = (float)((double)dist + (noise2.eval(px * 0.05, py * 0.05, pz * 0.05) * 0.01 + 0.01));
                dist = (float)((double)dist + (noise1.eval(px * 0.1, py * 0.1, pz * 0.1) * 0.005 + 0.005));
            }
            if (!(dist > 0.0f)) continue;
            LOCKER.unlock();
            return MathHelper.func_76128_c((double)((double)MathHelper.func_76131_a((float)((float)y + dist), (float)y, (float)(y + 1)) * 4.0));
        }
        LOCKER.unlock();
        return 0;
    }
}

